//
//  MCQueryExpressionView.h
//  MCApplication
//
//  Created by Michael Clark on 01/09/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCView.h"
#import "MCCSWCanvasView.h"


@class MCQueryElementView;
@class MCQueryCriteria;
@class MCPDocument;

@interface MCQueryExpressionView : MCCSWCanvasView {

	
	NSDictionary*              config;
	NSString*                  entityName;
	
	MCPDocument*   __document;
	
	id             __dataSource;
}

// ?? Not sure about this one....
- (void)synchronizeConfig;
// This might be temporary, replace by the above call
- (NSDictionary*)queryViewConfig;


- (MCQueryElementView*)addElementViewForCriteria: (MCQueryCriteria*)criteria withConfig: (NSDictionary*)aConfig;
- (MCQueryElementView*)addElementViewForCriteria: (MCQueryCriteria*)criteria;


- (NSDictionary *)config;
- (void)setConfig:(NSDictionary *)aConfig;

- (id)dataSource;
- (void)setDataSource:(id)aDataSource;

- (MCPDocument *)document;
- (void)setDocument:(MCPDocument *)aDocument;

- (NSString *)entityName;
- (void)setEntityName:(NSString *)anEntityName;

@end


@interface NSObject (MCQueryExpressionViewDataSource)

- (id)queryExpressionView: (MCQueryExpressionView*)view queryCriteriaForCriteriaIdentifier: (NSString*)identifier;

@end
